/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::  Module      :   Framework Module Configuration File
::  Copyright   :   (C)2002-2009 Woodward
::  Platform(s) :   MPC5xx
::  Dependants  :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __MODULECONFIG_H
#define __MODULECONFIG_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <ModuleDefn.h>

/*---- DEFINES --------------------------------------------------------------------------------------------*/

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef struct
{
    uint1 u1ConfigVerMaj;
    uint1 u1ConfigVerMin;
    uint1 BootVerMaj;
    uint1 BootVerMin;
    uint1 EcuHwMaj;
    uint1 EcuHwMin;
    E_ModuleCapability Capability;
    char const* psModelNumber;
    char const* psSerialNumber;
    uint1 DefaultCityID;
    uint4 DefaultCANBitRate;
    uint4 DefaultSerialBaudRate;
    uint4 BootSystemClockSpeed;
    char const* psPartNumber;
} S_ModuleConfig;

typedef S_ModuleConfig const* S_ModuleConfigTypePtr;

typedef struct
{
    uint1 HwMajor;
    uint1 HwMinor;
} S_HardwareCompatibilityEntry;

#pragma pack()

/*---- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/

INLINE S_ModuleConfig const* GetModuleConfig(void);

#endif /* __MODULECONFIG_H */

/*---- END OF FILE ----------------------------------------------------------------------------------------*/

